
import numpy as np

import scipy.ndimage as ndi
import pandas as pd

# 加载文件
# mat_data = scipy.io.loadmat("D:/Desktop/MMCR/云雷达数据/谱处理2018/谱处理2018/20180613_PU.mat")
# path="K:/shls/mmcr/2023_12m/z1_2023_12m_after1_1.21.csv"
# ttt="vr1_202101"
ttt="201908"
ls_list = ["ldr","z1","sw1","vr1","snr1"]


for item in ls_list:
    ls=item
    print(ttt+ls)
    # ttt="sw1_2023-09"
    # tt=ttt[-1]#10月要-2
    path="J:/BJ MMCR/BaseDat_C/csv/"+ttt+"/"+ls+"_"+ttt+"_after1.csv"
    # path="J:/NJ MMCR/hour/去噪后/"+ttt+"_after1.csv"
    # path="K:/sz after zhuanma/MMCR/hour时间补漏后/3月/z1_hour_after1_1.21.csv"  #
    mat_data = pd.read_csv(path)

    # 提取变量信息
    # times=np.array(mat_data['time(min)/height(m)'])
    # times = mat_data['time(min)/height(m)'].flatten()  # 将1×1416的数组展平为一维数组
    height=np.array(mat_data.columns[1:]).astype(float)

    datatime=mat_data['time(min)/height(m)']
    # yRange = mat_data['yRange'].flatten()  # 将1×669的数组展平为一维数组
    datals=mat_data.iloc[:,1:]
    z1 = datals.values  # 669×1416的数组
    # vr1 = mat_data['vr1']
    # 创建反射率变化情况图
    #plt.figure(figsize=(48, 6))


    #################################################################
    # 获取反射率数据
    data = datals.values  # numpy.ndarray格式数据
    print("1")
    # 将非空值变为1，空值变为0
    # 将nan替换为0，非nan替换为1
    data = np.where(np.isnan(data), 0, 1)

    # 定义侵蚀-膨胀算法
    def custom_erosion(input_array, kernel):
        result = np.zeros_like(input_array, dtype=int)
        rows, cols = input_array.shape
        k_height, k_width = kernel.shape

        for i in range(k_height // 2, rows - k_height // 2):
            for j in range(k_width // 2, cols - k_width // 2):
                if input_array[i, j] == 1:
                    # 如果卷积核的所有元素都在对应位置为1，则设置结果为1
                    if np.all(input_array[i - k_height // 2:i + k_height // 2 + 1,
                              j - k_width // 2:j + k_width // 2 + 1] * kernel == kernel):
                        result[i, j] = 1

        return result


    def custom_dilation(input_array, kernel):
        result = np.zeros_like(input_array, dtype=int)
        rows, cols = input_array.shape
        k_height, k_width = kernel.shape

        for i in range(k_height // 2, rows - k_height // 2):
            for j in range(k_width // 2, cols - k_width // 2):
                if input_array[i, j] == 1:
                    # 如果卷积核的任何元素在对应位置为1，则设置结果为1
                    if np.any(input_array[i - k_height // 2:i + k_height // 2 + 1,
                              j - k_width // 2:j + k_width // 2 + 1] * kernel == 1):
                        result[i, j] = 1

        return result


    # 定义侵蚀核
    erosion_kernel = np.array([[0, 1, 0],
                               [1, 1, 1],
                               [0, 1, 0]])

    # 定义膨胀核（结构元素）
    dilation_kernel = np.array([[1, 1, 1, 1, 1],
                                [1, 1, 1, 1, 1],
                                [1, 1, 1, 1, 1],
                                [1, 1, 1, 1, 1],
                                [1, 1, 1, 1, 1]])


    # 开运算
    # 侵蚀操作
    # 多次侵蚀-膨胀处理
    erosion_iterations = 1
    for i in range(erosion_iterations):
        data = custom_erosion(data, erosion_kernel)

    # 膨胀操作
    dilation_iterations = 1
    for i in range(dilation_iterations):
        data = custom_dilation(data, dilation_kernel)

    # 将处理后的数组与原数组进行逐元素相乘处理
    processed_data = data * z1

    # 将相乘得到的0值赋值为nan
    processed_z1 = np.where(processed_data == 0, np.nan, processed_data)

    print("2")
    ###########################################
    # 定义侵蚀-膨胀算法
    def custom_erosion2(input_array, kernel):
        nan_mask = np.isnan(input_array)  # 生成NaN掩码
        result = ndi.minimum_filter(input_array, footprint=kernel, mode='constant', cval=np.inf)
        result[nan_mask] = np.nan  # 将NaN值设置回NaN
        return result


    # 定义修改后的膨胀函数
    # 设置阈值行数
    threshold_row = 170

    # 记录原值，方便下面的恢复
    original_values = processed_z1.copy()

    # 将小于100的行设置为NaN#？？？？？待定改
    processed_z1[:threshold_row, :] = np.nan


    def custom_dilation2(input_array, kernel, threshold_row):
        output_array = np.copy(input_array)
        rows, cols = input_array.shape
        k_rows, k_cols = kernel.shape
        k_center = (k_rows // 2, k_cols // 2)

        for i in range(k_center[0], rows - k_center[0]):
            for j in range(k_center[1], cols - k_center[1]):
                if not np.isnan(input_array[i, j]):
                    continue

                max_val = -np.inf
                for ki in range(k_rows):
                    for kj in range(k_cols):
                        if kernel[ki, kj] == 1:
                            max_val = max(max_val, input_array[i - k_center[0] + ki, j - k_center[1] + kj])
                output_array[i, j] = max_val

        return output_array


    # 先闭后开
    # 闭运算，对小空洞进行处理
    dilation_iterations = 1
    for i in range(dilation_iterations):
        data = custom_dilation2(processed_z1, dilation_kernel, threshold_row)

    # 侵蚀运算
    erosion_iterations = 1
    for i in range(erosion_iterations):
        data = custom_erosion2(data, erosion_kernel)

    # 恢复行数小于100的值
    data[:threshold_row, :] = original_values[:threshold_row, :]
    print("3")

    print("4")
    # 将-inf替换为nan

    data=pd.DataFrame(data,columns=mat_data.columns[1:])
    data.replace(-np.inf, np.nan, inplace=True)
    datanew = pd.merge(datatime, data, left_index=True, right_index=True,how='left')
    #存
    # datanew.to_csv('K:/sz after zhuanma/MMCR/hour时间补漏后/3月/z1_hour_after2_1.21.csv',index=False)
    # datanew.to_csv('K:/shls/mmcr/2023_12m/z1_2023_12m_after2_1.21.csv',index=False)
    # datanew.to_csv("J:/NJ MMCR/21 6月及之前旧版数据/hour/去噪后/"+ttt+"_after2.csv",index=False)
    datanew.to_csv("J:/BJ MMCR/BaseDat_C/csv/"+ttt+"/"+ls+"_"+ttt+"_after2.csv",index=False)
    # datanew.to_csv("J:/NJ MMCR/hour/去噪后/"+ttt+"_after2.csv",index=False)

    # # 使用scipy.io.savemat函数将数组保存到MAT文件
    # #scipy.io.savemat('D:/Desktop/process_data/noice_process/2019/20190704.mat', variables_dict)  # 路径设置（英文路径）

    # # 显示图形
    # plt.show()


